/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge.challenges;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;

public class DisappearingBlocksChallenge
extends Challenge {
    private final Map<UUID, class_2338> lastPlayerPositions = new HashMap<UUID, class_2338>();
    private final Map<class_2338, Integer> scheduledBlocks = new LinkedHashMap<class_2338, Integer>();
    private final Set<class_2338> processedBlocks = new HashSet<class_2338>();
    private static final int DEFAULT_BLOCK_DISAPPEAR_DELAY = 10;
    private static final String SETTING_BLOCK_DISAPPEAR_DELAY = "block_disappear_delay";
    private static final int MAX_BLOCKS_PER_TICK = 10;
    public static final int MIN_DELAY = 1;
    public static final int MAX_DELAY = 60;
    private static final Set<class_2248> IMMORTAL_BLOCKS = new HashSet<class_2248>();

    public DisappearingBlocksChallenge() {
        super("disappearing_blocks", (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.disappearing_blocks.name"), (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.disappearing_blocks.description"), true, Challenge.MultiplayerStatus.MULTIPLAYER_COMPATIBLE);
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_BLOCK_DISAPPEAR_DELAY)) {
            ChallengeSettings.setIntOption(this.getId(), SETTING_BLOCK_DISAPPEAR_DELAY, 10);
        }
    }

    @Override
    public boolean isGameBeatable() {
        return true;
    }

    @Override
    public void onEnable() {
        this.lastPlayerPositions.clear();
        this.scheduledBlocks.clear();
        this.processedBlocks.clear();
    }

    @Override
    public void onDisable() {
        this.lastPlayerPositions.clear();
        this.scheduledBlocks.clear();
        this.processedBlocks.clear();
    }

    public int getBlockDisappearDelay() {
        return ChallengeSettings.getIntOption(this.getId(), SETTING_BLOCK_DISAPPEAR_DELAY, 10);
    }

    public void setBlockDisappearDelay(int delay) {
        ChallengeSettings.setIntOption(this.getId(), SETTING_BLOCK_DISAPPEAR_DELAY, delay);
    }

    private boolean shouldBlockDisappear(class_2248 block) {
        return !IMMORTAL_BLOCKS.contains(block);
    }

    public void checkPlayerMovement(class_1657 player) {
        class_2680 blockState;
        if (!this.isEnabled() || player.method_7325() || player.method_68878()) {
            return;
        }
        class_1937 world = player.method_37908();
        if (world.field_9236) {
            return;
        }
        UUID playerId = player.method_5667();
        class_2338 currentPos = player.method_24515().method_10074();
        class_2338 lastPos = this.lastPlayerPositions.get(playerId);
        this.lastPlayerPositions.put(playerId, currentPos);
        if (lastPos != null && !lastPos.equals((Object)currentPos) && !this.processedBlocks.contains(lastPos) && !this.scheduledBlocks.containsKey(lastPos) && !(blockState = world.method_8320(lastPos)).method_26215() && blockState.method_26214((class_1922)world, lastPos) >= 0.0f && this.shouldBlockDisappear(blockState.method_26204())) {
            this.scheduledBlocks.put(lastPos, this.getBlockDisappearDelay());
            this.processedBlocks.add(lastPos);
        }
        this.processScheduledBlocks(world);
    }

    private void processScheduledBlocks(class_1937 world) {
        if (this.scheduledBlocks.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<class_2338, Integer>> iterator = this.scheduledBlocks.entrySet().iterator();
        for (int processedCount = 0; iterator.hasNext() && processedCount < 10; ++processedCount) {
            Map.Entry<class_2338, Integer> entry = iterator.next();
            class_2338 pos = entry.getKey();
            int delay = entry.getValue() - 1;
            if (delay <= 0) {
                world.method_8503().execute(() -> world.method_8650(pos, false));
                iterator.remove();
                continue;
            }
            entry.setValue(delay);
        }
    }

    @Override
    public String getShowcaseVideoUrl() {
        return "https://youtu.be/wOaa8i01TZY";
    }

    static {
        IMMORTAL_BLOCKS.add(class_2246.field_9987);
        IMMORTAL_BLOCKS.add(class_2246.field_10540);
        IMMORTAL_BLOCKS.add(class_2246.field_10398);
    }
}

